/*
 * Decompiled with CFR 0.152.
 */
package in.projecteka.fidelius.dercyprion;

import in.projecteka.fidelius.dercyprion.DecryptionRequest;
import in.projecteka.fidelius.dercyprion.DecryptionResponse;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.KeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import javax.crypto.KeyAgreement;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.HKDFParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.util.encoders.Base64;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class DecryptionController {
    @PostMapping(value={"/decrypt"})
    public DecryptionResponse decrypt(@RequestBody DecryptionRequest decryptionRequest) throws Exception {
        byte[] xorOfRandom = this.xorOfRandom(decryptionRequest.getSenderNonce(), decryptionRequest.getReceiverNonce());
        String decryptedData = this.decrypt(xorOfRandom, decryptionRequest.getReceiverPrivateKey(), decryptionRequest.getSenderPublicKey(), decryptionRequest.getEncryptedData());
        return new DecryptionResponse(decryptedData);
    }

    private byte[] xorOfRandom(String senderNonce, String receiverNonce) {
        byte[] randomSender = this.getBytesForBase64String(senderNonce);
        byte[] randomReceiver = this.getBytesForBase64String(receiverNonce);
        byte[] combinedRandom = new byte[randomSender.length];
        for (int i = 0; i < randomSender.length; ++i) {
            combinedRandom[i] = (byte)(randomSender[i] ^ randomReceiver[i % randomReceiver.length]);
        }
        return combinedRandom;
    }

    public byte[] getBytesForBase64String(String value) {
        return Base64.decode((String)value);
    }

    public String decrypt(byte[] xorOfRandom, String receiverPrivateKey, String senderPublicKey, String stringToDecrypt) throws Exception {
        String sharedKey = this.doECDH(this.getBytesForBase64String(receiverPrivateKey), this.getBytesForBase64String(senderPublicKey));
        byte[] iv = Arrays.copyOfRange(xorOfRandom, xorOfRandom.length - 12, xorOfRandom.length);
        byte[] aesKey = this.generateAesKey(xorOfRandom, sharedKey);
        String decryptedData = "";
        byte[] encryptedBytes = this.getBytesForBase64String(stringToDecrypt);
        GCMBlockCipher cipher = new GCMBlockCipher((BlockCipher)new AESEngine());
        AEADParameters parameters = new AEADParameters(new KeyParameter(aesKey), 128, iv, null);
        cipher.init(false, (CipherParameters)parameters);
        byte[] plainBytes = new byte[cipher.getOutputSize(encryptedBytes.length)];
        int retLen = cipher.processBytes(encryptedBytes, 0, encryptedBytes.length, plainBytes, 0);
        cipher.doFinal(plainBytes, retLen);
        decryptedData = new String(plainBytes);
        return decryptedData;
    }

    private String doECDH(byte[] dataPrv, byte[] dataPub) throws Exception {
        KeyAgreement ka = KeyAgreement.getInstance("ECDH", "BC");
        ka.init(this.loadPrivateKey(dataPrv));
        ka.doPhase(this.loadPublicKeyForProjectEKAHIU(dataPub), true);
        byte[] secret = ka.generateSecret();
        return this.getBase64String(secret);
    }

    private PrivateKey loadPrivateKey(byte[] data) throws Exception {
        X9ECParameters ecP = CustomNamedCurves.getByName((String)"curve25519");
        ECParameterSpec params = new ECParameterSpec(ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
        ECPrivateKeySpec privateKeySpec = new ECPrivateKeySpec(new BigInteger(data), params);
        KeyFactory kf = KeyFactory.getInstance("ECDH", "BC");
        return kf.generatePrivate((KeySpec)privateKeySpec);
    }

    private PublicKey loadPublicKeyForProjectEKAHIU(byte[] data) throws Exception {
        KeyFactory ecKeyFac = KeyFactory.getInstance("ECDH", "BC");
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(data);
        PublicKey publicKey = ecKeyFac.generatePublic(x509EncodedKeySpec);
        return publicKey;
    }

    private byte[] generateAesKey(byte[] xorOfRandoms, String sharedKey) {
        byte[] salt = Arrays.copyOfRange(xorOfRandoms, 0, 20);
        HKDFBytesGenerator hkdfBytesGenerator = new HKDFBytesGenerator((Digest)new SHA256Digest());
        HKDFParameters hkdfParameters = new HKDFParameters(this.getBytesForBase64String(sharedKey), salt, null);
        hkdfBytesGenerator.init((DerivationParameters)hkdfParameters);
        byte[] aesKey = new byte[32];
        hkdfBytesGenerator.generateBytes(aesKey, 0, 32);
        return aesKey;
    }

    public String getBase64String(byte[] value) {
        return new String(Base64.encode((byte[])value));
    }
}

