/*
 * Decompiled with CFR 0.152.
 */
package in.projecteka.fidelius.encryotion;

import in.projecteka.fidelius.encryotion.EncryptionRequest;
import in.projecteka.fidelius.encryotion.EncryptionResponse;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.KeySpec;
import java.util.Arrays;
import javax.crypto.KeyAgreement;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.HKDFParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.util.encoders.Base64;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class EncryptionController {
    @PostMapping(value={"/encrypt"})
    public EncryptionResponse encrypt(@RequestBody EncryptionRequest encryptionRequest) throws Exception {
        byte[] xorOfRandom = this.xorOfRandom(encryptionRequest.getSenderNonce(), encryptionRequest.getReceiverNonce());
        String encryptedData = this.encrypt(xorOfRandom, encryptionRequest.getSenderPrivateKey(), encryptionRequest.getReceiverPublicKey(), encryptionRequest.getPlainTextData());
        String keyToShare = this.getBase64String(this.getEncodedHIPPublicKey(this.getKey(encryptionRequest.getSenderPublicKey())));
        return new EncryptionResponse(encryptedData, keyToShare);
    }

    private byte[] xorOfRandom(String senderNonce, String receiverNonce) {
        byte[] randomSender = this.getBytesForBase64String(senderNonce);
        byte[] randomReceiver = this.getBytesForBase64String(receiverNonce);
        byte[] combinedRandom = new byte[randomSender.length];
        for (int i = 0; i < randomSender.length; ++i) {
            combinedRandom[i] = (byte)(randomSender[i] ^ randomReceiver[i % randomReceiver.length]);
        }
        return combinedRandom;
    }

    public byte[] getBytesForBase64String(String value) {
        return Base64.decode((String)value);
    }

    public String encrypt(byte[] xorOfRandom, String senderPrivateKey, String receiverPublicKey, String stringToEncrypt) throws Exception {
        System.out.println("<------------------- ENCRYPTION -------------------->");
        String sharedKey = this.doECDH(this.getBytesForBase64String(senderPrivateKey), this.getBytesForBase64String(receiverPublicKey));
        byte[] iv = Arrays.copyOfRange(xorOfRandom, xorOfRandom.length - 12, xorOfRandom.length);
        byte[] aesKey = this.generateAesKey(xorOfRandom, sharedKey);
        String encryptedData = "";
        try {
            byte[] stringBytes = stringToEncrypt.getBytes();
            GCMBlockCipher cipher = new GCMBlockCipher((BlockCipher)new AESEngine());
            AEADParameters parameters = new AEADParameters(new KeyParameter(aesKey), 128, iv, null);
            cipher.init(true, (CipherParameters)parameters);
            byte[] plainBytes = new byte[cipher.getOutputSize(stringBytes.length)];
            int retLen = cipher.processBytes(stringBytes, 0, stringBytes.length, plainBytes, 0);
            cipher.doFinal(plainBytes, retLen);
            encryptedData = this.getBase64String(plainBytes);
        }
        catch (Exception e) {
            System.out.println(e.getLocalizedMessage());
        }
        System.out.println("EncryptedData: " + encryptedData);
        System.out.println("<---------------- Done ------------------->");
        return encryptedData;
    }

    private String doECDH(byte[] dataPrv, byte[] dataPub) throws Exception {
        KeyAgreement ka = KeyAgreement.getInstance("ECDH", "BC");
        ka.init(this.loadPrivateKey(dataPrv));
        ka.doPhase(this.loadPublicKey(dataPub), true);
        byte[] secret = ka.generateSecret();
        return this.getBase64String(secret);
    }

    private PrivateKey loadPrivateKey(byte[] data) throws Exception {
        X9ECParameters ecP = CustomNamedCurves.getByName((String)"curve25519");
        ECParameterSpec params = new ECParameterSpec(ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
        ECPrivateKeySpec privateKeySpec = new ECPrivateKeySpec(new BigInteger(data), params);
        KeyFactory kf = KeyFactory.getInstance("ECDH", "BC");
        return kf.generatePrivate((KeySpec)privateKeySpec);
    }

    private PublicKey loadPublicKey(byte[] data) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        X9ECParameters ecP = CustomNamedCurves.getByName((String)"curve25519");
        ECParameterSpec ecNamedCurveParameterSpec = new ECParameterSpec(ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
        return KeyFactory.getInstance("ECDH", "BC").generatePublic((KeySpec)new ECPublicKeySpec(ecNamedCurveParameterSpec.getCurve().decodePoint(data), ecNamedCurveParameterSpec));
    }

    private byte[] generateAesKey(byte[] xorOfRandoms, String sharedKey) {
        byte[] salt = Arrays.copyOfRange(xorOfRandoms, 0, 20);
        HKDFBytesGenerator hkdfBytesGenerator = new HKDFBytesGenerator((Digest)new SHA256Digest());
        HKDFParameters hkdfParameters = new HKDFParameters(this.getBytesForBase64String(sharedKey), salt, null);
        hkdfBytesGenerator.init((DerivationParameters)hkdfParameters);
        byte[] aesKey = new byte[32];
        hkdfBytesGenerator.generateBytes(aesKey, 0, 32);
        return aesKey;
    }

    public String getBase64String(byte[] value) {
        return new String(Base64.encode((byte[])value));
    }

    public byte[] getEncodedHIPPublicKey(PublicKey key) {
        ECPublicKey ecKey = (ECPublicKey)key;
        return ecKey.getEncoded();
    }

    public PublicKey getKey(String key) throws Exception {
        byte[] bytesForBase64String = this.getBytesForBase64String(key);
        PublicKey publicKey = this.loadPublicKey(bytesForBase64String);
        return publicKey;
    }
}

